unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Menus;

type
  TForm1 = class(TForm)
    mm: TMainMenu;
    mmiFichier: TMenuItem;
    mmiCharger: TMenuItem;
    mmiSauvegarder: TMenuItem;
    mmiFormat: TMenuItem;
    mmiFont: TMenuItem;
    mmiCouleur: TMenuItem;
    mmiAuteur: TMenuItem;
    gbSaisie: TGroupBox;
    lblSaisie: TLabel;
    edtNom: TEdit;
    btnAjouter: TButton;
    lbNoms: TListBox;
    N1: TMenuItem;
    mmiVider: TMenuItem;
    dlgOpen: TOpenDialog;
    dlgSave: TSaveDialog;
    dlgFont: TFontDialog;
    dlgColor: TColorDialog;
    mmiExit: TMenuItem;
    btnExit: TButton;
    procedure mmiViderClick(Sender: TObject);
    procedure mmiChargerClick(Sender: TObject);
    procedure mmiSauvegarderClick(Sender: TObject);
    procedure mmiFontClick(Sender: TObject);
    procedure mmiCouleurClick(Sender: TObject);
    procedure mmiAuteurClick(Sender: TObject);
    procedure btnAjouterClick(Sender: TObject);
    procedure mmiExitClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.mmiViderClick(Sender: TObject);
begin
  lbNoms.Clear
end;

procedure TForm1.mmiChargerClick(Sender: TObject);
begin
  if dlgOpen.Execute then
    lbNoms.Items.LoadFromFile(dlgOpen.FileName)
end;

procedure TForm1.mmiSauvegarderClick(Sender: TObject);
begin
  dlgSave.FileName:=dlgOpen.FileName;
  if dlgSave.Execute then
    lbNoms.Items.SaveToFile(dlgSave.FileName)
end;

procedure TForm1.mmiFontClick(Sender: TObject);
begin
  dlgFont.Font:=lbNoms.Font;
  if dlgFont.Execute then
    lbNoms.Font:=dlgFont.Font
end;

procedure TForm1.mmiCouleurClick(Sender: TObject);
begin
  dlgColor.Color:=lbNoms.Color;
  if dlgColor.Execute then
    lbNoms.Color:=dlgColor.Color
end;

procedure TForm1.mmiAuteurClick(Sender: TObject);
begin
  ShowMessage('Auteur : Arsne Lebon')
end;

procedure TForm1.btnAjouterClick(Sender: TObject);
begin
  lbNoms.Items.Add(edtNom.Text)
end;

procedure TForm1.mmiExitClick(Sender: TObject);
begin
   Form1.Close;
end;

end.
